<?php defined('SYSPATH') or die('No direct script access.');

class Task_Insert_Client_Add extends Minion_Task{

	protected function _execute(array $params){
        Task_Helper::createWorker('Insert:Client:Add', $this);
	}

    public function Worker(GearmanJob $job){
        $data = json_decode($job->workload(), true);

        $test = DB::select('id')
            ->from('clients')
            ->where('cid0','=', $data['cid0'])
            ->where('cid1','=', $data['cid1'])
            ->where('prefix','=', $data['prefix'])
            ->limit(1)
            ->execute()
            ->as_array();

        if(empty($test)) {
            $fileds = [
                'version',
                'cid0',
                'cid1',
                'prefix',
                'net',
                'system',
                'ip',
                'location',
                'registered',
                'lastactivity'
            ];

            $test = DB::insert('clients', $fileds)
                ->values(Arr::extract($data, $fileds))
                ->execute();
            return json_encode([0 => ['id' => $test[0] ]]);
        }else{
            return json_encode($test);
        }
    }
}